local spellbook = Action()

function spellbook.onUse(player, item, fromPosition, target, toPosition, isHotkey)
	local text = {}
	local spells = {}
	for _, spell in ipairs(player:getInstantSpells()) do
		if spell.level ~= 0 then
			if spell.manapercent > 0 then
				spell.mana = spell.manapercent .. "%"
			end
			spells[#spells + 1] = spell
		end
	end

	table.sort(spells, function(a, b) return a.level < b.level end)

	local prevLevel = -1
	for i, spell in ipairs(spells) do
		if prevLevel ~= spell.level then
			if i == 1 then
				text[#text == nil and 1 or #text+1] = "Spells for Level "
			else
				text[#text+1] = "\nSpells for Level "
			end
			text[#text+1] = spell.level .. "\n"
			prevLevel = spell.level
		end
		text[#text+1] = spell.words .. " - " .. spell.name .. " : " .. spell.mana .. "\n"
	end

	player:showTextDialog(item:getId(), table.concat(text))
	return true
end

spellbook:id(3059, 6120, 8900, 8901, 8902, 8903, 8904, 8918, 14769, 16107, 20088, 20089, 20090, 21400)
spellbook:register()
